#version 140
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Cut n_projectMod01.fsh   by  knighty   
//https://www.shadertoy.com/view/XdtBzH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*--------------------------------------------------------------------------
 Aperiodic tiling
 by knighty (april 2018)
 License: Free
 Info: Uses cut and project method. The pixel is tested for which tile it 
       belongs to. Unlike The usual method that draws the tiles "one by one"
       thus have cost proportionnal to the number of drawn tiles, the cost
       per pixel in this shader is bound by a -rather big- constant. 
       ... WIP :o)
 For an interactive version, see: https://www.shadertoy.com/view/Xs3fDr

 Some references (both by Greg Egan.):
 - https://plus.google.com/u/0/113086553300459368002/posts/VJBnyhxH44y
   (With a cool aniated gif that visually explains almost every thing.)
 - https://plus.google.com/u/0/113086553300459368002/posts/aMm17RELcsJ
   (With links to articles and applets)
--------------------------------------------------------------------------*/


//the two vectors defining the cut and project plane
const float udir[5] = float[5](0.632456, 0.19544, -0.511667, -0.511667, 0.19544);
const float vdir[5] = float[5](0., 0.601501, 0.371748, -0.371748, -0.601501);
//the 3 directions perpendicular to the cut and project plane
const float u2dir[5] = float[5](0.632456, -0.511667, 0.19544, 0.19544, -0.511667);
const float v2dir[5] = float[5](0., 0.371748, -0.601501, 0.601501, -0.371748);
const float adir[5] = float[5](0.447214, 0.447214, 0.447214, 0.447214, 0.447214);
//Cut and project plane origin
float CPO[5];

//results of tiling search
struct Data{
	float dist;
	ivec2 sides;
	vec2 posInTile;
};

void init(){
	float CP_tans_u2dir = 0.; 
    float CP_tans_v2dir = 0.;
    float CP_tans_adir  = 2.2*sin(iTime*0.25);
    for(int i=0; i<5; i++)
		CPO[i] = CP_tans_u2dir * u2dir[i] + CP_tans_v2dir * v2dir[i] + CP_tans_adir * adir[i];
}

//Gives the coordinates of the point (x,y) on the "cutting" plane into the 5D space
float[5] P2E5(vec2 z){
	float p[5];
	for(int i=0; i<5; i++)
		p[i] = CPO[i] + z.x * udir[i] + z.y * vdir[i];
	return p;
}

//given a point p, return the nearest vertex in the lattice and the offset.
void getRoundAndOffest(in float[5] p, out float[5] ip, out float[5] ofs){
	for(int i=0; i<5; i++){
		ip[i] = round(p[i]);
		ofs[i] = p[i] - ip[i];
	}
}

//given a vector Ofs, return the vector of 1 when component >0 and -1 otherwise 
float[5] getOfsDir(float[5] ofs){
	float dir[5];
	for(int i=0; i<5; i++){
		//if(ofs[i]>0.) dir[i]=1.; else dir[i]=-1.;
		//dir[i] = 2. * float(ofs[i] > 0.) - 1.;
        dir[i] = ofs[i] > 0. ? 1. : -1.;
	}
	return dir;
}

//project the vector ofs onto the plane (udir,vdir)
vec2 projectOfs(float[5] ofs){
   //dot products
	vec2 pofs = vec2(0);
	for(int i=0; i<5; i++){
		pofs.x += ofs[i] * udir[i];
		pofs.y += ofs[i] * vdir[i];
	}
	return pofs;
}

//Distance from a to the parallelogramm defined
//by u and v. a is expressed in the (u,v) basis
float Dist22V2(vec2 a, float f){
	vec2 p = abs(a - .5) - .5;//abs(a-vec2(.5))-vec2(.5);
	return max(p.x, p.y) * f;//
}

//Finds if p is inside a the tile defined by (i,j,ip)
//dir is not per se necessary it could be se to 1s
Data section(int i, int j, float[5] p, float[5] ip, mat2 m, float f, vec2 s){
    //check intersection with dual
    vec2 lhs = vec2(ip[i] - CPO[i], ip[j] - CPO[j]) + 0.5*s;
	vec2 z = lhs * m;
	
    float[5]  ofs, q;
	q = P2E5(z);
	//the intersection can be on a neighbouring tile!
	for(int k=0; k<5; k++){
		q[k] = floor(q[k]+.5);
		if(k==i)      ofs[k]=p[k] - (ip[k] + .5 * (s.x - 1.));
        else if(k==j) ofs[k]=p[k] - (ip[k] + .5 * (s.y - 1.));
		else          ofs[k]=p[k] - q[k];
	}
	
	vec2 pofs = projectOfs(ofs);
	
	//get the face corresponding to the intersected dual
    vec2 pit = (m * pofs);
    
	float dist   = Dist22V2(pit, f);
	Data d1 = Data(dist, ivec2(i,j), pit);
	return d1;
}

//
Data DE(vec2 z){

	float[5] p = P2E5(z);
	
	float[5] ip, ofs, dir;
	getRoundAndOffest(p,ip,ofs);
    // dir is the preferred direction. Most of the tiling shows up thanks to it.
    // comment "#define NO_GLITCH" below to see the difference
    // Now faster thanks to dir and coherent branching :).
    // One may notice that when zooming out (a lot) it slows down.
    dir = getOfsDir(ofs);
#define NO_GLITCH

	for(int i=0; i<4; i++)
		for(int j=i+1; j<5; j++)
		{
			//m and f can/should be precomputed!
            // the inverse of m is used to test if:
            // - the projection of p onto cutting plane is inside the current tile
            // - the cut plane intersects the dual of the current tile
            mat2 m = mat2(vec2(udir[i],vdir[i]), vec2(udir[j],vdir[j]));
            // f is a correction factor to get the distance to the boundary of the tile
    		float f = dot(m[0],m[1]); f = sqrt(dot(m[0],m[0]) - f*f / dot(m[1],m[1]));
            //We use the inverse of m in reality :D
    		m = inverse(m);
            
            //Scan the diffrent possible 4 directions
            Data d1 = section(i, j, p, ip, m, f, vec2(dir[i],dir[j]));
			if(d1.dist < 0.) return d1;
		}
    
#ifdef NO_GLITCH    
    for(int i=0; i<4; i++)
		for(int j=i+1; j<5; j++)
		{
			//m and f can/should be precomputed!
            // the inverse of m is used to test if:
            // - the projection of p onto cutting plane is inside the current tile
            // - the cut plane intersects the dual of the current tile
            mat2 m = mat2(vec2(udir[i],vdir[i]), vec2(udir[j],vdir[j]));
            // f is a correction factor to get the distance to the boundary of the tile
    		float f = dot(m[0],m[1]); f = sqrt(dot(m[0],m[0]) - f*f / dot(m[1],m[1]));
            //We use the inverse of m in reality :D
    		m = inverse(m);
            
            vec2 s = vec2(1.,-1.);
            //Scan the diffrent possible 4 directions
            Data d1 = section(i, j, p, ip, m, f, vec2(-dir[i],dir[j]));
			if(d1.dist < 0.) return d1;

			d1 = section(i, j, p, ip, m, f, vec2(dir[i],-dir[j]));
			if(d1.dist < 0.) return d1;
			
			d1 = section(i, j, p, ip, m, f, vec2(-dir[i],-dir[j]));
			if(d1.dist < 0.) return d1;
		}
#endif
    
	return Data(0., ivec2(0), vec2(0));
}

//-------------------------------------------------------------------------------------------
// End of aperiodic tiling
//-------------------------------------------------------------------------------------------

float getFaceSurf(int i, int j){
    float k = abs(float(j-i)-2.5);
    return (k+0.5) * 0.2;
	/*vec2 u,v;
	u[0]=udir[i]; u[1]=vdir[i];
	v[0]=udir[j]; v[1]=vdir[j];
	return abs(u[0]*v[1]-u[1]*v[0]);*/
}

float coverageFunction(float t){
	//this function returns the area of the part of the unit disc that is at the rigth of the verical line x=t.
	//the exact coverage function is:
	//t=clamp(t,-1.,1.); return (acos(t)-t*sqrt(1.-t*t))/PI;
	//this is a good approximation
	return 1.-smoothstep(-1.,1.,t);
	//a better approximation:
	//t=clamp(t,-1.,1.); return (t*t*t*t-5.)*t*1./8.+0.5;//but there is no visual difference
}

#define DRadius .75
#define Width 1.5
#define BackgroundColor vec3(1)
#define CurveColor vec3(0)
#define Gamma 2.2
float coverageLine(float d, float lineWidth, float pixsize){
	d=d*1./pixsize;
	float v1=(d-0.5*lineWidth)/DRadius;
	float v2=(d+0.5*lineWidth)/DRadius;
	return coverageFunction(v1)-coverageFunction(v2);
}

vec3 color(vec2 pos) {
	float pixsize=dFdx(pos.x);
	Data data = DE(pos);
	float v=coverageLine(abs(data.dist), Width, pixsize);
    
	vec3 faceCol = vec3(getFaceSurf(data.sides.x, data.sides.y)*3.5);
    //vec3 faceCol = vec3(data.posInTile,0.);
    faceCol *= texture2D(texture1,0.5*data.posInTile).rgb;
    
	return mix(BackgroundColor*faceCol,CurveColor,v);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
	vec2 p = 5. * (2.0 * fragCoord.xy - iResolution.xy) / iResolution.y;
	init();
    fragColor = vec4(color(p), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
//vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc); // * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

